/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BedTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.CampfireTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndGatewayTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EndPortalTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.LecternTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.MobSpawnerTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.PistonTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ShulkerBoxTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.StructureTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class TileEntityRendererDispatcher {
    private final Map<TileEntityType<?>, TileEntityRenderer<?>> field_147559_m = Maps.newHashMap();
    public static final TileEntityRendererDispatcher field_147556_a = new TileEntityRendererDispatcher();
    private final BufferBuilder field_228849_g_ = new BufferBuilder(256);
    private FontRenderer field_147557_n;
    public TextureManager field_147553_e;
    public World field_147550_f;
    public ActiveRenderInfo field_217666_g;
    public RayTraceResult field_190057_j;

    private TileEntityRendererDispatcher() {
        this.func_228854_a_(TileEntityType.field_200978_i, new SignTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200979_j, new MobSpawnerTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200980_k, new PistonTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200972_c, new ChestTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200974_e, new ChestTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200973_d, new ChestTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200982_m, new EnchantmentTableTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_222485_C, new LecternTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200983_n, new EndPortalTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200991_v, new EndGatewayTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200984_o, new BeaconTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200985_p, new SkullTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200989_t, new BannerTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200990_u, new StructureTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_200993_x, new ShulkerBoxTileEntityRenderer(new ShulkerModel(), this));
        this.func_228854_a_(TileEntityType.field_200994_y, new BedTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_205166_z, new ConduitTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_222486_D, new BellTileEntityRenderer(this));
        this.func_228854_a_(TileEntityType.field_222488_F, new CampfireTileEntityRenderer(this));
    }

    private <E extends TileEntity> void func_228854_a_(TileEntityType<E> tileEntityType, TileEntityRenderer<E> tileEntityRenderer) {
        this.field_147559_m.put(tileEntityType, tileEntityRenderer);
    }

    @Nullable
    public <E extends TileEntity> TileEntityRenderer<E> func_147547_b(E e) {
        return this.field_147559_m.get(e.func_200662_C());
    }

    public void func_217665_a(World world, TextureManager textureManager, FontRenderer fontRenderer, ActiveRenderInfo activeRenderInfo, RayTraceResult rayTraceResult) {
        if (this.field_147550_f != world) {
            this.func_147543_a(world);
        }
        this.field_147553_e = textureManager;
        this.field_217666_g = activeRenderInfo;
        this.field_147557_n = fontRenderer;
        this.field_190057_j = rayTraceResult;
    }

    public <E extends TileEntity> void func_228850_a_(E e, float f, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer) {
        if (!Vector3d.func_237489_a_(e.func_174877_v()).func_237488_a_(this.field_217666_g.func_216785_c(), e.func_145833_n())) {
            return;
        }
        TileEntityRenderer tileEntityRenderer = this.func_147547_b(e);
        if (tileEntityRenderer == null) {
            return;
        }
        if (!e.func_145830_o() || !e.func_200662_C().func_223045_a(e.func_195044_w().func_177230_c())) {
            return;
        }
        TileEntityRendererDispatcher.func_228853_a_(e, () -> TileEntityRendererDispatcher.func_228855_a_(tileEntityRenderer, e, f, matrixStack, iRenderTypeBuffer));
    }

    private static <T extends TileEntity> void func_228855_a_(TileEntityRenderer<T> tileEntityRenderer, T t, float f, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer) {
        World world = t.func_145831_w();
        int \u26032 = world != null ? WorldRenderer.func_228421_a_(world, t.func_174877_v()) : 0xF000F0;
        tileEntityRenderer.func_225616_a_(t, f, matrixStack, iRenderTypeBuffer, \u26032, OverlayTexture.field_229196_a_);
    }

    public <E extends TileEntity> boolean func_228852_a_(E e, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int n, int n2) {
        TileEntityRenderer tileEntityRenderer = this.func_147547_b(e);
        if (tileEntityRenderer == null) {
            return true;
        }
        TileEntityRendererDispatcher.func_228853_a_(e, () -> tileEntityRenderer.func_225616_a_(e, 0.0f, matrixStack, iRenderTypeBuffer, n, n2));
        return false;
    }

    private static void func_228853_a_(TileEntity tileEntity, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering Block Entity");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block Entity Details");
            tileEntity.func_145828_a(\u26032);
            throw new ReportedException(crashReport);
        }
    }

    public void func_147543_a(@Nullable World world) {
        this.field_147550_f = world;
        if (world == null) {
            this.field_217666_g = null;
        }
    }

    public FontRenderer func_147548_a() {
        return this.field_147557_n;
    }
}

